package fr.unice.polytech.ocs.connectedwavews.services;

import javax.ws.rs.*;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path("/shark")
public interface SharkAlertWS {

    @GET
    @Path("/test")
    public String test ();

    @Path("/test/{what}")
    @GET
    public String test (@PathParam("what") String what);

    @GET
    @Path("/alert")
    public String getAlert ();

    @GET
    @Path("/alert/bool")
    public boolean underAlert ();

    @GET
    @Path("/alert/without_coordinates")
    public void setAlertWithoutCoordinates ();

    @POST
    @Path("/alert/lat/lon")
    public String setAlert (@PathParam("lat") double lat, @PathParam("lon") double lon);

    @GET
    @Path("/alert/remove_all")
    public void removeAllAlerts();

}

/**
@XmlRootElement(name = "sharkalertresult")
class SharkAlertResult {
    private String sharkalertresult;
    @XmlElement(name = "sharkalertresult")
    public String getSharkAlertResult() { return sharkalertresult; }
    public void setSharkAlertResult(String sharkalertresult) { this.sharkalertresult = sharkalertresult; }

    public SharkAlertResult() { this.sharkalertresult = new String(); }
}
 */
