package fr.unice.polytech.ocs.connectedwavews.services;

import fr.unice.polytech.ocs.connectedwavews.business.SharkAlert;
import fr.unice.polytech.ocs.connectedwavews.persistance.DAO;
import fr.unice.polytech.ocs.connectedwavews.utils.Utils;

import javax.ejb.EJB;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SharkAlertWSImpl implements SharkAlertWS {

    @EJB
    private DAO dao;


    @Override
    public String test() {
        return "---------- Hello World! :D ---------- [Shark Alert]";
    }

    @Override
    public String test(String what) {
        return "---------- Hello World! :D " + what + " ---------- [Shark Alert]";
    }


    @Override
    public String getAlert() {
        boolean alert;
        if ( dao.getSharkAlert().size() > 0 ) alert = true;
        else alert = false;

        String result = new String();
        result.concat("---------- Current alert? " + alert + " ---------- [Shark Alert]");
        if ( alert ) {
            Utils tools = new Utils();
            double latitude_test = tools.getLatitudeTest();
            double longitude_test = tools.getLongitudeTest();

            boolean perimeterPresence = Utils.checkIfInPerimeterShark(latitude_test, longitude_test);
            result.concat("\nAre you in the alert perimeter? " + perimeterPresence + " ---------- [Shark Alert]");
        }
        return result;
    }

    @Override
    public boolean underAlert () {

        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("New request underAlert? at: " + sdf.format(cal.getTime()));

        Utils tools = new Utils();

        double latitude_test = tools.getLatitudeTest();
        double longitude_test = tools.getLongitudeTest();

        // TODO
        boolean alert;
        if ( dao.getSharkAlert().size() > 0 ) alert = true;
        else alert = false;

        boolean perimeterPresence = false;
        if ( alert ) {
            perimeterPresence = Utils.checkIfInPerimeterShark(latitude_test, longitude_test);
        }
        return perimeterPresence;
    }

    @Override
    public void setAlertWithoutCoordinates () {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("New Shark Alert (setAlertWithoutCoordinates) at: " + sdf.format(cal.getTime()));

        Utils tools = new Utils();
        String result = new String();
        result.concat("---------- /!\\ NEW ALERT (WithoutCoordinates) /!\\ ---------- [Shark Alert]");
        dao.addSharkAlert(tools.getLatitude(), tools.getLongitude());
        // return result;
    }


    @Override
    public String setAlert(double lat, double lon) {
        String result = new String();
        result.concat("---------- /!\\ NEW ALERT /!\\ ---------- [Shark Alert]");
        dao.addSharkAlert(lat, lon);
        return result;
    }

    @Override
    public void removeAllAlerts() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("[ - ] Sharks Alerts release at: " + sdf.format(cal.getTime()));
        dao.getSharkAlert().clear();
    }

}
