﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Threading;
using NAudio;
using NAudio.WindowsMediaFormat;
using System.IO;
using System.Net;
using NAudio.Wave;
using System.Web;
using System.Speech.Synthesis;

namespace client
{   //client
    public partial class Form1 : Form
    {
        private const int portNum = 4545;
        delegate void SetTextCallback(string text);

        TcpClient client;
        NetworkStream ns;
        Thread t = null;
        private const string hostName = "192.168.43.111";

        /*delegate void SetTextCallback(string text);
        TcpListener listener=null;
        TcpClient client;
        NetworkStream ns;
        Thread t = null;*/


        public Form1()
        {
            InitializeComponent();
            this.WindowState = FormWindowState.Maximized; 
            this.FormBorderStyle = FormBorderStyle.None;
            label1.AutoSize = true;
            label1.Height = this.Height*2/3;
           // label1.Font.Size= label1.Height * 2 / 3;
            /*IPHostEntry ipHost = Dns.Resolve(Dns.GetHostName());
            IPAddress ipAddr = ipHost.AddressList[0];
            label2.Text = "IP: " + ipAddr.ToString();*/

            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            String s = textBox2.Text;
            byte[] byteTime = Encoding.ASCII.GetBytes(s);
            ns.Write(byteTime, 0, byteTime.Length);

        }


        // This is run as a thread
        public void DoWork()
        {
            byte[] bytes = new byte[1024];
            while (true)
            {
                int bytesRead = ns.Read(bytes, 0, bytes.Length);
                this.SetText(Encoding.ASCII.GetString(bytes, 0, bytesRead));
                //MessageBox.Show(Encoding.ASCII.GetString(bytes, 0, bytesRead));
            }
        }

        public TextBox my { get { return this.textBox1; } }
        public void SetText(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBox1.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBox1.Text = this.textBox1.Text + text;
                label1.Text = text;
                //var playThread = new Thread(() => PlayMp3FromUrl("http://translate.google.com/translate_tts?q=" + HttpUtility.UrlEncode(text)));
                //var playThread = new Thread(() => PlayMp3FromUrl("http://api.voicerss.org/?key=7d274e62cc5e4e76bb3b2e4c661b97db&src=" + HttpUtility.UrlEncode(text)+"&hl=fr-fr"));
                //playThread.IsBackground = true;
                //playThread.Start();

                SpeechSynthesizer synthesizer = new SpeechSynthesizer();
                synthesizer.Volume = 100;  //00 0...100
                synthesizer.Rate = -2;     // -10...108


                // Synchronous
                //synthesizer.Speak("Hello World");

                // Asynchronous
                synthesizer.SpeakAsync(text);
                //Console.WriteLine(text);
            }
        }

        bool waiting = false;
        AutoResetEvent stop = new AutoResetEvent(false);
        public void PlayMp3FromUrl(string url)
        {
            using (Stream ms = new MemoryStream())
            {
                using (Stream stream = WebRequest.Create(url)
                    .GetResponse().GetResponseStream())
                {
                    byte[] buffer = new byte[32768];
                    int read;
                    while ((read = stream.Read(buffer, 0, buffer.Length)) > 0)
                    {
                        ms.Write(buffer, 0, read);
                    }
                }

                ms.Position = 0;
                using (WaveStream blockAlignedStream =
                    new BlockAlignReductionStream(
                        WaveFormatConversionStream.CreatePcmStream(
                            new Mp3FileReader(ms))))
                {
                    using (WaveOut waveOut = new WaveOut(WaveCallbackInfo.FunctionCallback()))
                    {
                        waveOut.Init(blockAlignedStream);
                        waveOut.PlaybackStopped += (sender, e) =>
                        {
                            waveOut.Stop();
                        };

                        waveOut.Play();
                        waiting = true;
                        stop.WaitOne(10000);
                        waiting = false;
                    }
                }
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            client = new TcpClient(hostName, portNum);
            ns = client.GetStream();
            String s = "Connected";
            byte[] byteTime = Encoding.ASCII.GetBytes(s);
            ns.Write(byteTime, 0, byteTime.Length);
            t = new Thread(DoWork);
            t.Start();

            /*listener = new TcpListener(4545);
            listener.Start();
            client = listener.AcceptTcpClient();
            ns = client.GetStream();
            String s = "Connected";
            byte[] byteTime = Encoding.ASCII.GetBytes(s);
            ns.Write(byteTime, 0, byteTime.Length);
            t = new Thread(DoWork);
            t.Start();*/

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.timer1.Interval = 50;
            this.timer1.Enabled = true;
            this.WindowState = FormWindowState.Maximized;

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            label1.Left = label1.Left - 3; 
            if (label1.Right < 0) {
                label1.Left = this.Width; 
            }
        }

        private void label1_Click(object sender, EventArgs e)
        {
            //this.Close();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (t != null)
            {
                //listener.Stop();
                client.Close();
                t.Abort();
            }
            System.Diagnostics.Process.GetCurrentProcess().Kill();
            this.Close();
        }

        private void label2_Click(object sender, EventArgs e)
        {

        }
    }
}
