# PyUPnP - Simple Python UPnP device library built in Twisted
# Copyright (C) 2013  Dean Gardiner <gardiner91@gmail.com>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# Doc & examples : https://github.com/fuzeman/PyUPnP

import logging
from threading import Thread
import time
from twisted.internet import reactor
from pyupnp.event import EventProperty
from pyupnp.device import Device, DeviceIcon
from pyupnp.logr import Logr
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
from pyupnp.ssdp import SSDP
from pyupnp.upnp import UPnP
from manchon_services.lcd import *
from manchon_services.actuator import ActuatorService
from manchon_services.waterflow import WaterFlowService
from manchon_services.temperature import TemperatureService
from manchon_services.touch import TouchService
import grovepi
from grovepi import *
import random

sensor = 14     # Pin 14 is A0 Port.
grovepi.pinMode(sensor,"INPUT")

class ManchonDevice(Device):
    deviceType = 'urn:schemas-upnp-org:device:Manchon:1'
    friendlyName = "The smart manchon"
    
    def __init__(self):
        Device.__init__(self)
        self.uuid='2fac1234-31f8-11b4-a222-08002b34c003'
        self.lcdservice = LCDService()
        self.tempservice = TemperatureService()
        self.actuatorservice = ActuatorService()
        self.waterflowservice = WaterFlowService()
        self.touchservice = TouchService()
        
        self.services = [
            self.lcdservice,
            self.tempservice,
            self.actuatorservice,
            self.waterflowservice,
            self.touchservice
        ]
        self.waterflowservice.startListening()
        self.touchservice.startListening()
        self.tempservice.startListening()
        
        self.icons = [DeviceIcon('image/png', 32, 32, 24,'http://172.25.3.103:52323/MediaRenderer_32x32.png')]

        
if __name__ == '__main__':
    Logr.configure(logging.DEBUG)

    device = ManchonDevice()

    upnp = UPnP(device)
    ssdp = SSDP(device)

    upnp.listen()
    ssdp.listen()
    setText("Le manchon est  connecte")
    for i in range(0,51):
        setRGB(random.randint(0,255),random.randint(0,255),random.randint(0,255))
        time.sleep(.1)
    reactor.run()
    
        