import logging
from threading import Thread
import time
from twisted.internet import reactor
from pyupnp.event import EventProperty
from pyupnp.device import Device, DeviceIcon
from pyupnp.logr import Logr
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
from pyupnp.ssdp import SSDP
from pyupnp.upnp import UPnP
import time
import grovepi
from grovepi import *

# Connect the Grove LED to digital port D6
vanne = 6
pinMode(vanne,"OUTPUT")


class ActuatorService(Service):
	version = (1, 0)
	serviceType = "urn:schemas-upnp-org:service:Actuator:1"
	serviceId = "urn:upnp-org:serviceId:Actuator"

	actions = {
		'GetState': [
			ServiceActionArgument('Water','out','WaterState'),
		],
		
		'OpenWater': [
			ServiceActionArgument('Input', 'in', 'ARG_WATER_STATE'),
			ServiceActionArgument('Ouput', 'out', 'ARG_WATER_STATE')
		]
	}
	
	stateVariables = [
		# Arguments
		ServiceStateVariable('ARG_WATER_STATE',         'boolean'),
        
		# Variables
		ServiceStateVariable('WaterState','boolean',sendEvents=True)
	]
	
	state=EventProperty('WaterState')

	@register_action('GetState')
	def getState(self):
		return {
			'Water' : self.state
		}
		
	@register_action('OpenWater')
	def openWater(self,param):
		if(param == "1"):
			digitalWrite(vanne, 255)
			self.state = True
		elif(param == "0"):
			digitalWrite(vanne, 0)
			self.state = False
		type(param)
		print param
		return 5