// UPnP .NET Framework Device Stack, Device Module
// Device Builder Build#1.0.5329.22110

using System;
using OpenSource.UPnP;
using OpenSource.DeviceBuilder;

namespace OpenSource.DeviceBuilder
{
	/// <summary>
	/// Summary description for SampleDevice.
	/// </summary>
	class SampleDevice
	{
		private UPnPDevice device;
		
		public SampleDevice()
		{
			device = UPnPDevice.CreateRootDevice(1800,1.0,"\\");
			
			device.FriendlyName = "Mydevice";
			device.Manufacturer = "OpenSource";
			device.ManufacturerURL = "http://opentools.homeip.net";
			device.ModelName = "Sample Auto-Generated Device";
			device.ModelDescription = "Sample UPnP Device Using Auto-Generated UPnP Stack";
			device.ModelNumber = "X1";
			device.HasPresentation = false;
			device.DeviceURN = "urn:schemas-upnp-org:device:Sample:1";
			OpenSource.DeviceBuilder.DvremotehelpService remotehelpService = new OpenSource.DeviceBuilder.DvremotehelpService();
			remotehelpService.External_getLogin = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getLogin(remotehelpService_getLogin);
			remotehelpService.External_getSendedT = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getSendedT(remotehelpService_getSendedT);
			remotehelpService.External_getStateCAM = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getStateCAM(remotehelpService_getStateCAM);
			remotehelpService.External_setLogin = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setLogin(remotehelpService_setLogin);
			remotehelpService.External_setMessqge = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setMessqge(remotehelpService_setMessqge);
			remotehelpService.External_setStateCAM = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setStateCAM(remotehelpService_setStateCAM);
			device.AddService(remotehelpService);
			
			// Setting the initial value of evented variables
		}
		
		public void Start()
		{
			device.StartDevice();
		}
		
		public void Stop()
		{
			device.StopDevice();
		}
		
		public void remotehelpService_getLogin(out System.Boolean Arg1)
		{
			Arg1 = false;
			Console.WriteLine("remotehelpService_getLogin(" + ")");
		}
		
		public void remotehelpService_getSendedT(out System.String Arg1)
		{
			Arg1 = "Sample String";
			Console.WriteLine("remotehelpService_getSendedT(" + ")");
		}
		
		public void remotehelpService_getStateCAM(out System.Boolean Arg1)
		{
			Arg1 = false;
			Console.WriteLine("remotehelpService_getStateCAM(" + ")");
		}
		
		public void remotehelpService_setLogin(System.Boolean Arg1, out System.String Arg2)
		{
			Arg2 = "Sample String";
			Console.WriteLine("remotehelpService_setLogin(" + Arg1.ToString() + ")");
		}
		
		public void remotehelpService_setMessqge(System.String Arg1)
		{
			Console.WriteLine("remotehelpService_setMessqge(" + Arg1.ToString() + ")");
		}
		
		public void remotehelpService_setStateCAM(System.Boolean Arg1, out System.String Arg2)
		{
			Arg2 = "Sample String";
			Console.WriteLine("remotehelpService_setStateCAM(" + Arg1.ToString() + ")");
		}
		
	}
}

