// UPnP .NET Framework Device Stack, Device Module
// Device Builder Build#1.0.5329.22110

using System;
using OpenSource.UPnP;
using System.Windows.Forms;
using OpenSource.DeviceBuilder;
using client;
using System.Diagnostics;
using System.Threading;
using System.Net.Sockets;
using System.IO;
using System.Net;

namespace OpenSource.DeviceBuilder
{
	/// <summary>
	/// Summary description for SampleDevice.
	/// </summary>
	class SampleDevice
	{
		private UPnPDevice device;
		private Boolean isLogin=false;
        private Boolean isOpenCAM=false;
        private String lastsendedString="";
        private Process proc = null;
        private Thread t = null;
        private Thread tf = null;
        client.Form1 a;
        public SampleDevice()
		{
			device = UPnPDevice.CreateRootDevice(1800,1.0,"\\");
			
			device.FriendlyName = "Mydevice";
			device.Manufacturer = "OpenSource";
			device.ManufacturerURL = "http://opentools.homeip.net";
			device.ModelName = "Sample Auto-Generated Device";
			device.ModelDescription = "Sample UPnP Device Using Auto-Generated UPnP Stack";
			device.ModelNumber = "X1";
			device.HasPresentation = false;
			device.DeviceURN = "urn:schemas-upnp-org:device:Sample:1";
			OpenSource.DeviceBuilder.DvremotehelpService remotehelpService = new OpenSource.DeviceBuilder.DvremotehelpService();
			remotehelpService.External_getLogin = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getLogin(remotehelpService_getLogin);
			remotehelpService.External_getSendedT = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getSendedT(remotehelpService_getSendedT);
			remotehelpService.External_getStateCAM = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_getStateCAM(remotehelpService_getStateCAM);
			remotehelpService.External_setLogin = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setLogin(remotehelpService_setLogin);
			remotehelpService.External_setMessqge = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setMessqge(remotehelpService_setMessqge);
			remotehelpService.External_setStateCAM = new OpenSource.DeviceBuilder.DvremotehelpService.Delegate_setStateCAM(remotehelpService_setStateCAM);
			device.AddService(remotehelpService);
           
			// Setting the initial value of evented variables
		}
		public void showForm()
        {
            a = new Form1();
            a.SetText("Bonjour");
            //Application.Run(a);
            a.ShowDialog();
            

        }
		public void Start()
		{
            //a = new Form1();
            
            //Application.Run(a);
            device.StartDevice();
            tf = new Thread(showForm);
            tf.Start();
        }
		
		public void Stop()
		{
            if (tf!=null)
            {
                //tf.Abort();
            }
			device.StopDevice();
		}
		
		public void remotehelpService_getLogin(out System.Boolean Arg1)
		{
			Arg1 = isLogin;
            
            Console.WriteLine("remotehelpService_getLogin(" + ")");
		}
		
		public void remotehelpService_getSendedT(out System.String Arg1)
		{
            //
			Arg1 = lastsendedString;
			Console.WriteLine("remotehelpService_getSendedT(" + ")");
		}
		
		public void remotehelpService_getStateCAM(out System.Boolean Arg1)
		{
			Arg1 = isOpenCAM;
			Console.WriteLine("remotehelpService_getStateCAM(" + ")");
		}
		
		public void remotehelpService_setLogin(System.Boolean Arg1, out System.String Arg2)
		{
            if (Arg1==true)
            {
                if (isLogin==true)
                {
                    Arg2 = "Already connected";
                }
                else
                {
                    isLogin = true;
                    Arg2 = "Connection Success";
                }
            }
            else
            {

                if (isLogin == true)
                {
                    isLogin = false;
                    Arg2 = "Disconnected";
                }
                else
                {
                    Arg2 = "havent connected";
                }
            }
            
			Console.WriteLine("remotehelpService_setLogin(" + Arg1.ToString() + ")");
		}
		
		public void remotehelpService_setMessqge(System.String Arg1)
		{
            lastsendedString = Arg1;
            a.SetText(Arg1);
            //
            Console.WriteLine("remotehelpService_setMessqge(" + Arg1.ToString() + ")");
		}
		public void playVLC()
        {
            //proc = 
            proc = new Process();
            isOpenCAM = true;
            proc.StartInfo.FileName = "C:\\Program Files\\VideoLAN\\VLC\\vlc.exe";
            proc.StartInfo.Arguments = "dshow:// :dshow-vdev=\"USB 2.0 PC Cam\" :dshow-adev=\"none\" --sout=#transcode{vcodec=mp2v,vb=800,acodec=mpga,ab=128,channels=2,samplerate=44100}:http{mux=ts,dst=:8081/stream}";
            proc.Start();
            proc.WaitForExit();
            //var exitCode = proc.ExitCode;
            proc.Close();
        }
		public void remotehelpService_setStateCAM(System.Boolean Arg1, out System.String Arg2)
		{
            
            if (isLogin==true) {
                if (Arg1 == true)
                {
                    if (isOpenCAM == true)
                    {
                        Arg2 = "Already opened";
                    }
                    else
                    {
                        isOpenCAM = true;
                        //
                        t = new Thread(playVLC);
                        t.Start();
                        Arg2 = "Open Success";
                    }
                }
                else
                {
                    if (isOpenCAM == true)
                    {
                        isOpenCAM = false;
                        //
                        if (t !=null)
                        {
                            proc.Kill();
                            t.Abort();
                        }
                        Arg2 = "Closed";
                    }
                    else
                    {
                        Arg2 = "havent opened";
                    }
                }
            }
            else
            {
                Arg2 = "havent login";
            }
            Console.WriteLine("remotehelpService_setStateCAM(" + Arg1.ToString() + ")");
		}
		
	}
}

