using OpenSource.UPnP;

namespace OpenSource.DeviceBuilder
{
    /// <summary>
    /// Transparent DeviceSide UPnP Service
    /// </summary>
    public class DvsampleService : IUPnPService
    {

        // Place your declarations above this line

        #region AutoGenerated Code Section [Do NOT Modify, unless you know what you're doing]
        //{{{{{ Begin Code Block

        private _DvsampleService _S;
        public static string URN = "urn:schemas-upnp-org:service:sampleService:1";
        public double VERSION
        {
           get
           {
               return(double.Parse(_S.GetUPnPService().Version));
           }
        }

        public delegate void OnStateVariableModifiedHandler(DvsampleService sender);
        public event OnStateVariableModifiedHandler OnStateVariableModified_sampleTyple;
        public event OnStateVariableModifiedHandler OnStateVariableModified_sampleEvent;
        public System.Int32 sampleTyple
        {
            get
            {
               return((System.Int32)_S.GetStateVariable("sampleTyple"));
            }
            set
            {
               _S.SetStateVariable("sampleTyple", value);
            }
        }
        public System.String Evented_sampleEvent
        {
            get
            {
               return((System.String)_S.GetStateVariable("sampleEvent"));
            }
            set
            {
               _S.SetStateVariable("sampleEvent", value);
            }
        }
        public UPnPModeratedStateVariable.IAccumulator Accumulator_sampleTyple
        {
            get
            {
                 return(((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleTyple")).Accumulator);
            }
            set
            {
                 ((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleTyple")).Accumulator = value;
            }
        }
        public double ModerationDuration_sampleTyple
        {
            get
            {
                 return(((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleTyple")).ModerationPeriod);
            }
            set
            {
                 ((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleTyple")).ModerationPeriod = value;
            }
        }
        public UPnPModeratedStateVariable.IAccumulator Accumulator_sampleEvent
        {
            get
            {
                 return(((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleEvent")).Accumulator);
            }
            set
            {
                 ((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleEvent")).Accumulator = value;
            }
        }
        public double ModerationDuration_sampleEvent
        {
            get
            {
                 return(((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleEvent")).ModerationPeriod);
            }
            set
            {
                 ((UPnPModeratedStateVariable)_S.GetUPnPService().GetStateVariableObject("sampleEvent")).ModerationPeriod = value;
            }
        }
        public delegate void Delegate_sampleAction(System.Int32 Arg1, out System.Int32 Arg2);

        public Delegate_sampleAction External_sampleAction = null;

        public void RemoveStateVariable_sampleTyple()
        {
            _S.GetUPnPService().RemoveStateVariable(_S.GetUPnPService().GetStateVariableObject("sampleTyple"));
        }
        public void RemoveStateVariable_sampleEvent()
        {
            _S.GetUPnPService().RemoveStateVariable(_S.GetUPnPService().GetStateVariableObject("sampleEvent"));
        }
        public void RemoveAction_sampleAction()
        {
             _S.GetUPnPService().RemoveMethod("sampleAction");
        }
        public System.Net.IPEndPoint GetCaller()
        {
             return(_S.GetUPnPService().GetCaller());
        }
        public System.Net.IPEndPoint GetReceiver()
        {
             return(_S.GetUPnPService().GetReceiver());
        }

        private class _DvsampleService
        {
            private DvsampleService Outer = null;
            private UPnPService S;
            internal _DvsampleService(DvsampleService n)
            {
                Outer = n;
                S = BuildUPnPService();
            }
            public UPnPService GetUPnPService()
            {
                return(S);
            }
            public void SetStateVariable(string VarName, object VarValue)
            {
               S.SetStateVariable(VarName,VarValue);
            }
            public object GetStateVariable(string VarName)
            {
               return(S.GetStateVariable(VarName));
            }
            protected UPnPService BuildUPnPService()
            {
                UPnPStateVariable[] RetVal = new UPnPStateVariable[2];
                RetVal[0] = new UPnPModeratedStateVariable("sampleTyple", typeof(System.Int32), false);
                RetVal[0].SetRange((System.Int32)(1),(System.Int32)(10),null);
                RetVal[0].AddAssociation("sampleAction", "Arg1");
                RetVal[0].AddAssociation("sampleAction", "Arg2");
                RetVal[1] = new UPnPModeratedStateVariable("sampleEvent", typeof(System.String), true);

                UPnPService S = new UPnPService(1, "urn:upnp-org:serviceId:sampleService", URN, true, this);
                for(int i=0;i<RetVal.Length;++i)
                {
                   S.AddStateVariable(RetVal[i]);
                }
                S.AddMethod("sampleAction");
                return(S);
            }

            public void sampleAction(System.Int32 Arg1, out System.Int32 Arg2)
            {
                if (Outer.External_sampleAction != null)
                {
                    Outer.External_sampleAction(Arg1, out Arg2);
                }
                else
                {
                    Sink_sampleAction(Arg1, out Arg2);
                }
            }

            public Delegate_sampleAction Sink_sampleAction;
        }
        public DvsampleService()
        {
            _S = new _DvsampleService(this);
            _S.GetUPnPService().GetStateVariableObject("sampleTyple").OnModified += new UPnPStateVariable.ModifiedHandler(OnModifiedSink_sampleTyple);
            _S.GetUPnPService().GetStateVariableObject("sampleEvent").OnModified += new UPnPStateVariable.ModifiedHandler(OnModifiedSink_sampleEvent);
            _S.Sink_sampleAction = new Delegate_sampleAction(sampleAction);
        }
        public DvsampleService(string ID):this()
        {
            _S.GetUPnPService().ServiceID = ID;
        }
        public UPnPService GetUPnPService()
        {
            return(_S.GetUPnPService());
        }
        private void OnModifiedSink_sampleTyple(UPnPStateVariable sender, object NewValue)
        {
            if (OnStateVariableModified_sampleTyple != null) OnStateVariableModified_sampleTyple(this);
        }
        private void OnModifiedSink_sampleEvent(UPnPStateVariable sender, object NewValue)
        {
            if (OnStateVariableModified_sampleEvent != null) OnStateVariableModified_sampleEvent(this);
        }
        //}}}}} End of Code Block

        #endregion

        /// <summary>
        /// Action: sampleAction
        /// </summary>
        /// <param name="Arg1">Associated State Variable: sampleTyple</param>
        /// <param name="Arg2">Associated State Variable: sampleTyple</param>
        public void sampleAction(System.Int32 Arg1, out System.Int32 Arg2)
        {
            //ToDo: Add Your implementation here, and remove exception
            throw(new UPnPCustomException(800,"This method has not been completely implemented..."));
        }
    }
}