// UPnP .NET Framework Device Stack, Device Module
// Device Builder Build#1.0.5329.22110

using System;
using OpenSource.UPnP;
using OpenSource.DeviceBuilder;
using System.Diagnostics;
using client;

namespace OpenSource.DeviceBuilder
{
	/// <summary>
	/// Summary description for SampleDevice.
	/// </summary>
	class SampleDevice
	{
		private UPnPDevice device;
		
		public SampleDevice()
		{
			device = UPnPDevice.CreateRootDevice(1800,1.0,"\\");
			
			device.FriendlyName = "Mydevice";
			device.Manufacturer = "OpenSource";
			device.ManufacturerURL = "http://opentools.homeip.net";
			device.ModelName = "Sample Auto-Generated Device";
			device.ModelDescription = "Sample UPnP Device Using Auto-Generated UPnP Stack";
			device.ModelNumber = "X1";
			device.HasPresentation = false;
			device.DeviceURN = "urn:schemas-upnp-org:device:Sample:1";
			OpenSource.DeviceBuilder.DvsampleService sampleService = new OpenSource.DeviceBuilder.DvsampleService();
			sampleService.External_sampleAction = new OpenSource.DeviceBuilder.DvsampleService.Delegate_sampleAction(sampleService_sampleAction);
			device.AddService(sampleService);
			
			// Setting the initial value of evented variables
			sampleService.Evented_sampleEvent = "Sample String";
		}
		
		public void Start()
		{
			device.StartDevice();
		}
		
		public void Stop()
		{
			device.StopDevice();
		}
		
		public void sampleService_sampleAction(System.Int32 Arg1, out System.Int32 Arg2)
		{
			Arg2 = 0;
			Console.WriteLine("sampleService_sampleAction(" + Arg1.ToString() + ")");

            var proc = new Process();
            proc.StartInfo.FileName = "F:\\Program Files (x86)\\VideoLAN\\VLC\\vlc.exe";
            proc.StartInfo.Arguments = "dshow:// :dshow-vdev=\"HP Truevision HD\" :dshow-adev=\"none\" --sout=#transcode{vcodec=mp2v,vb=800,acodec=mpga,ab=128,channels=2,samplerate=44100}:http{mux=ts,dst=:8081/stream}";
            proc.Start();
            //proc.WaitForExit();
            //var exitCode = proc.ExitCode;
            proc.Close();

		}
		
	}
}

