﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using DecibelTracker.Resources;
using System.Windows.Documents;
using System.IO;
using System.Windows.Threading;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework;

namespace DecibelTracker
{
    public partial class MainPage : PhoneApplicationPage
    {
        Microphone microphone = Microphone.Default;
        byte[] buffer;
        MemoryStream stream = new MemoryStream();
        List<double> dataMicro = new List<double>();
        double[][] rawData;
        static int bufferDurationMicrophoneMs = 1000;
        static int numClusters = 3;
        static int maxShownByCluster = 8;
        static int maxVectorShown = 20;
        static double[][] means;
        // Constructeur
        public MainPage()
        {
            InitializeComponent();
            //son
            DispatcherTimer dt = new DispatcherTimer();
            dt.Interval = TimeSpan.FromMilliseconds(50);
            dt.Tick += delegate { try { FrameworkDispatcher.Update(); } catch { } };
            dt.Start();
            microphone.BufferReady += new EventHandler<EventArgs>(microphone_BufferReady);

            // real data likely to come from a text file or SQL
            /*double[][] rawData = new double[20][];
            rawData[0] = new double[] { 65.0, 220.0 };
            rawData[1] = new double[] { 73.0, 160.0 };
            rawData[2] = new double[] { 59.0, 110.0 };
            rawData[3] = new double[] { 61.0, 120.0 };
            rawData[4] = new double[] { 75.0, 150.0 };
            rawData[5] = new double[] { 67.0, 240.0 };
            rawData[6] = new double[] { 68.0, 230.0 };
            rawData[7] = new double[] { 70.0, 220.0 };
            rawData[8] = new double[] { 62.0, 130.0 };
            rawData[9] = new double[] { 66.0, 210.0 };
            rawData[10] = new double[] { 77.0, 190.0 };
            rawData[11] = new double[] { 75.0, 180.0 };
            rawData[12] = new double[] { 74.0, 170.0 };
            rawData[13] = new double[] { 70.0, 210.0 };
            rawData[14] = new double[] { 61.0, 110.0 };
            rawData[15] = new double[] { 58.0, 100.0 };
            rawData[16] = new double[] { 66.0, 230.0 };
            rawData[17] = new double[] { 59.0, 120.0 };
            rawData[18] = new double[] { 68.0, 210.0 };
            rawData[19] = new double[] { 61.0, 130.0 };*/
            
                       
        }
        //=============================================================================
        private void resetDatas()
        {
            dataMicro = new List<double>();
            rawData = null;
            means = null;
        }

        //=============================================================================
        private void resetUI()
        {
            reset_button.IsEnabled = false;
            resultBlock.Text = AppResources.DefaultResultBlockLabel;
            FirstColLabel.Visibility = Visibility.Collapsed;
            FirstCol.Text = "";
            SecondColLabel.Visibility = Visibility.Collapsed;
            SecondCol.Text = "";
            ThirdColLabel.Visibility = Visibility.Collapsed;
            ThirdCol.Text = "";
        }
        //=============================================================================
        void affichageResult(double[][] rawData)
        {
            /*resultBlock.Text = ("    Height Weight");
            resultBlock.Inlines.Add(new LineBreak());
            resultBlock.Text += ("-------------------");
            resultBlock.Inlines.Add(new LineBreak());
            ShowData(rawData, 1, true, true);*/

            int[] clustering = Cluster(rawData, numClusters); // this is it
            if(clustering == null)
            {
                resultBlock.Text = "Quantity of datas insufficient. Record for at least "+(numClusters*bufferDurationMicrophoneMs)+" milliseconds.";
                resetDatas();
                return;
            }
            /*resultBlock.Inlines.Add(new LineBreak());
            resultBlock.Text = ("Setting numClusters to " + numClusters);
            resultBlock.Inlines.Add(new LineBreak());*/
            resetUI();
            resultBlock.Text = "";
            resultBlock.Text += ("K-means clustering complete : "+rawData.Length+" datas recorded");
            resultBlock.Inlines.Add(new LineBreak());


            resultBlock.Inlines.Add(new LineBreak());
            resultBlock.Text += ("Means by cluster:");
            double[] clusterMeans = new double[numClusters];
            for(int k = 0; k < numClusters; k++)
            {
                double sum = 0;
                int count = 0;
                for(int i = 0; i < rawData.Length; i++)
                {
                    if (clustering[i] == k)
                    {
                        sum += rawData[i][0];
                        count++;
                    }
                }
                clusterMeans[k] = sum / count;
            }
            int indexMin = 0;
            int indexMax = 0;
            for (int k = 0; k < numClusters; k++)
            {
                if (clusterMeans[indexMin] >= clusterMeans[k])
                {
                    indexMin = k;
                }
                if (clusterMeans[indexMax] <= clusterMeans[k])
                {
                    indexMax = k;
                }
            }

            for (int k = 0; k < numClusters; k++)
            {
                resultBlock.Inlines.Add(new LineBreak());
                resultBlock.Text += " - Cluster " + k;
                if (k == indexMin) resultBlock.Text += " (quietest)";
                else if (k == indexMax) resultBlock.Text += " (noisiest)";
                else resultBlock.Text += " (medium noisy)";
                resultBlock.Text += " = ";
                resultBlock.Text += clusterMeans[k].ToString("F" + 8);
            }

            resultBlock.Inlines.Add(new LineBreak());
            resultBlock.Text += ("Final clustering in internal form:");
            resultBlock.Inlines.Add(new LineBreak());
            ShowVector(clustering, true);

            resultBlock.Text += ("Raw data by cluster:");
            resultBlock.Inlines.Add(new LineBreak());
            ShowClustered(rawData, clustering, numClusters, 4);
            reset_button.IsEnabled = true;
        }
        //=============================================================================
        void microphone_BufferReady(object sender, EventArgs e)
        {
            microphone.GetData(buffer);
            stream.Write(buffer, 0, buffer.Length);


            double sum = 0;

            for (var i = 0; i < buffer.Length; i = i + 2)

            {

                double sample = BitConverter.ToInt16(buffer, i) / 32768.0;

                sum += (sample * sample);

            }

            double rms = Math.Sqrt(sum / buffer.Length);

            double decibel = 92.8 + 20 * Math.Log10(rms);
            //decibel_textbox.Text = decibel.ToString("0.######") + "dB";

            //enregistrement données
            dataMicro.Add(rms);
        }

        private void record_button_Click(object sender, RoutedEventArgs e)
        {
            Button btn = (Button)sender;
            if (btn.Content.ToString() == "Record")
            {
                microphone.BufferDuration = TimeSpan.FromMilliseconds(bufferDurationMicrophoneMs);
                buffer = new byte[microphone.GetSampleSizeInBytes(microphone.BufferDuration)];
                microphone.Start();
                btn.Content = "Stop";
            }
            else
            {
                if (microphone.State == MicrophoneState.Started)
                {
                    microphone.Stop();
                    btn.Content = "Record";
                    rawData = new double[dataMicro.Count][];
                    int i = 0;
                    foreach(double data in dataMicro){
                        rawData[i] = new double[1] { data };
                        i++;
                    }
                    affichageResult(rawData);
                }
            }
        }

        // ============================================================================

        public static int[] Cluster(double[][] rawData, int numClusters)
        {
            // k-means clustering
            // index of return is tuple ID, cell is cluster ID
            // ex: [2 1 0 0 2 2] means tuple 0 is cluster 2, tuple 1 is cluster 1, tuple 2 is cluster 0, tuple 3 is cluster 0, etc.
            // an alternative clustering DS to save space is to use the .NET BitArray class
            double[][] data = Normalized(rawData); // so large values don't dominate
            if(data == null)
            {
                return null;
            }

            bool changed = true; // was there a change in at least one cluster assignment?
            bool success = true; // were all means able to be computed? (no zero-count clusters)

            // init clustering[] to get things started
            // an alternative is to initialize means to randomly selected tuples
            // then the processing loop is
            // loop
            //    update clustering
            //    update means
            // end loop
            int[] clustering = InitClustering(data.Length, numClusters, 0); // semi-random initialization
            means = Allocate(numClusters, data[0].Length); // small convenience

            int maxCount = data.Length * 10; // sanity check
            int ct = 0;
            while (changed == true && success == true && ct < maxCount)
            {
                ++ct; // k-means typically converges very quickly
                success = UpdateMeans(data, clustering); // compute new cluster means if possible. no effect if fail
                changed = UpdateClustering(data, clustering); // (re)assign tuples to clusters. no effect if fail
            }
            return clustering;
        }

        private static double[][] Normalized(double[][] rawData)
        {
            // normalize raw data by computing (x - mean) / stddev
            // primary alternative is min-max:
            // v' = (v - min) / (max - min)
            
            // make a copy of input data
            if(rawData.Length < numClusters)
            {
                return null;
            }
            double[][] result = new double[rawData.Length][];
            for (int i = 0; i < rawData.Length; ++i)
            {
                result[i] = new double[rawData[i].Length];
                Array.Copy(rawData[i], result[i], rawData[i].Length);
            }
            for (int j = 0; j < result[0].Length; ++j) // each col
            {
                double colSum = 0.0;
                for (int i = 0; i < result.Length; ++i)
                    colSum += result[i][j];
                double mean = colSum / result.Length;
                double sum = 0.0;
                for (int i = 0; i < result.Length; ++i)
                    sum += (result[i][j] - mean) * (result[i][j] - mean);
                double sd = sum / result.Length;
                for (int i = 0; i < result.Length; ++i)
                    result[i][j] = (result[i][j] - mean) / sd;
            }
            return result;
        }

        private static int[] InitClustering(int numTuples, int numClusters, int randomSeed)
        {
            // init clustering semi-randomly (at least one tuple in each cluster)
            // consider alternatives, especially k-means++ initialization,
            // or instead of randomly assigning each tuple to a cluster, pick
            // numClusters of the tuples as initial centroids/means then use
            // those means to assign each tuple to an initial cluster.
            Random random = new Random(randomSeed);
            int[] clustering = new int[numTuples];
            for (int i = 0; i < numClusters; ++i) // make sure each cluster has at least one tuple
                clustering[i] = i;
            for (int i = numClusters; i < clustering.Length; ++i)
                clustering[i] = random.Next(0, numClusters); // other assignments random
            return clustering;
        }

        private static double[][] Allocate(int numClusters, int numColumns)
        {
            // convenience matrix allocator for Cluster()
            double[][] result = new double[numClusters][];
            for (int k = 0; k < numClusters; ++k)
                result[k] = new double[numColumns];
            return result;
        }

        private static bool UpdateMeans(double[][] data, int[] clustering)
        {
            // returns false if there is a cluster that has no tuples assigned to it
            // parameter means[][] is really a ref parameter

            // check existing cluster counts
            // can omit this check if InitClustering and UpdateClustering
            // both guarantee at least one tuple in each cluster (usually true)
            int numClusters = means.Length;
            int[] clusterCounts = new int[numClusters];
            for (int i = 0; i < data.Length; ++i)
            {
                int cluster = clustering[i];
                ++clusterCounts[cluster];
            }

            for (int k = 0; k < numClusters; ++k)
                if (clusterCounts[k] == 0)
                    return false; // bad clustering. no change to means[][]

            // update, zero-out means so it can be used as scratch matrix 
            for (int k = 0; k < means.Length; ++k)
                for (int j = 0; j < means[k].Length; ++j)
                    means[k][j] = 0.0;

            for (int i = 0; i < data.Length; ++i)
            {
                int cluster = clustering[i];
                for (int j = 0; j < data[i].Length; ++j)
                    means[cluster][j] += data[i][j]; // accumulate sum
            }

            for (int k = 0; k < means.Length; ++k)
                for (int j = 0; j < means[k].Length; ++j)
                    means[k][j] /= clusterCounts[k]; // danger of div by 0
            return true;
        }

        private static bool UpdateClustering(double[][] data, int[] clustering)
        {
            // (re)assign each tuple to a cluster (closest mean)
            // returns false if no tuple assignments change OR
            // if the reassignment would result in a clustering where
            // one or more clusters have no tuples.

            int numClusters = means.Length;
            bool changed = false;

            int[] newClustering = new int[clustering.Length]; // proposed result
            Array.Copy(clustering, newClustering, clustering.Length);

            double[] distances = new double[numClusters]; // distances from curr tuple to each mean

            for (int i = 0; i < data.Length; ++i) // walk thru each tuple
            {
                for (int k = 0; k < numClusters; ++k)
                    distances[k] = Distance(data[i], means[k]); // compute distances from curr tuple to all k means

                int newClusterID = MinIndex(distances); // find closest mean ID
                if (newClusterID != newClustering[i])
                {
                    changed = true;
                    newClustering[i] = newClusterID; // update
                }
            }

            if (changed == false)
                return false; // no change so bail and don't update clustering[][]

            // check proposed clustering[] cluster counts
            int[] clusterCounts = new int[numClusters];
            for (int i = 0; i < data.Length; ++i)
            {
                int cluster = newClustering[i];
                ++clusterCounts[cluster];
            }

            for (int k = 0; k < numClusters; ++k)
                if (clusterCounts[k] == 0)
                    return false; // bad clustering. no change to clustering[][]

            Array.Copy(newClustering, clustering, newClustering.Length); // update
            return true; // good clustering and at least one change
        }

        private static double Distance(double[] tuple, double[] mean)
        {
            // Euclidean distance between two vectors for UpdateClustering()
            // consider alternatives such as Manhattan distance
            double sumSquaredDiffs = 0.0;
            for (int j = 0; j < tuple.Length; ++j)
                sumSquaredDiffs += Math.Pow((tuple[j] - mean[j]), 2);
            return Math.Sqrt(sumSquaredDiffs);
        }

        private static int MinIndex(double[] distances)
        {
            // index of smallest value in array
            // helper for UpdateClustering()
            int indexOfMin = 0;
            double smallDist = distances[0];
            for (int k = 0; k < distances.Length; ++k)
            {
                if (distances[k] < smallDist)
                {
                    smallDist = distances[k];
                    indexOfMin = k;
                }
            }
            return indexOfMin;
        }

        // ============================================================================

        // misc display helpers for demo

        void ShowData(double[][] data, int decimals, bool indices, bool newLine)
        {
            for (int i = 0; i < data.Length; ++i)
            {
                if (indices) resultBlock.Text += (i.ToString().PadLeft(3) + " ");
                for (int j = 0; j < data[i].Length; ++j)
                {
                    if (data[i][j] >= 0.0) resultBlock.Text += " ";
                    resultBlock.Text += (data[i][j].ToString("F" + decimals) + " ");
                }
                resultBlock.Inlines.Add(new LineBreak());
            }
            if (newLine) resultBlock.Inlines.Add(new LineBreak());
        } // ShowData

        void ShowVector(int[] vector, bool newLine)
        {
            for (int i = 0; i < vector.Length; ++i)
            {
                if(i >= maxVectorShown)
                {
                    resultBlock.Text += "...";
                    break;
                }
                resultBlock.Text += (vector[i] + " ");
            }
            if (newLine) resultBlock.Inlines.Add(new LineBreak());
        }

        void ShowClustered(double[][] data, int[] clustering, int numClusters, int decimals)
        {
            FirstColLabel.Visibility = Visibility.Visible;
            SecondColLabel.Visibility = Visibility.Visible;
            ThirdColLabel.Visibility = Visibility.Visible;
            string line;
            int[] numShownByCluster = new int[numClusters];
            for (int k = 0; k < numClusters; ++k)
            {
                numShownByCluster[k] = 0;
                TextBlock t = null;
                switch (k)
                {
                    case 0: t = FirstCol; break;
                    case 1: t = SecondCol; break;
                    case 2: t = ThirdCol; break;
                }
                for (int i = 0; i < data.Length; ++i)
                {
                    int clusterID = clustering[i];
                    if (clusterID != k) continue;
                    if (numShownByCluster[k] == maxShownByCluster)
                    {
                        t.Text += "...";
                        t.Inlines.Add(new LineBreak());
                        numShownByCluster[k]++;
                        continue;
                    } else if(numShownByCluster[k] > maxShownByCluster)
                    {
                        continue;
                    }
                    //line = (i.ToString().PadLeft(3) + " ");
                    line = ""+data[i].Length+" : ";
                    for (int j = 0; j < data[i].Length; ++j)
                    {
                        if (data[i][j] >= 0.0002) line += (" ");
                        line += (data[i][j].ToString("F" + decimals) + " ");
                    }
                    if(t != null)
                    {
                        t.Text += line;
                        t.Inlines.Add(new LineBreak());
                        numShownByCluster[k]++;
                    }
                }
            } // k
        }

        private void reset_button_Click(object sender, RoutedEventArgs e)
        {
            resetDatas();
            resetUI();
        }
    }
}