﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using Windows.Devices.Sensors;
using Windows.Foundation;
using Windows.UI.Core;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using static Windows.Devices.Sensors.LightSensor;

// Pour en savoir plus sur le modèle d'élément Page vierge, consultez la page http://go.microsoft.com/fwlink/?LinkId=391641

namespace PhoneApp1
{
    /// <summary>
    /// Une page vide peut être utilisée seule ou constituer une page de destination au sein d'un frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        private bool updateAcceleroPaused;
        private bool updateLightPaused;
        private bool capturing;
        private readonly Accelerometer accelerometer;
        private LightSensor lightSensor;
        private Kmin kminAccelero;
        private Kmin kminLight;
        private double previousAx;
        private double previousAy;
        private double previousAz;
        
        private int biggestShockCluster;

        private String[] lightClusters;

        public MainPage()
        {
            this.InitializeComponent();

            this.NavigationCacheMode = NavigationCacheMode.Required;

            accelerometer = Accelerometer.GetDefault();
            accelerometer.ReadingChanged += new TypedEventHandler<Accelerometer, AccelerometerReadingChangedEventArgs>(accelerometerHandler);
            this.updateAcceleroPaused = true;
            this.updateLightPaused = true;
            this.capturing = true;

            lightSensor = LightSensor.GetDefault();
            uint minReportInterval = lightSensor.MinimumReportInterval;
            lightSensor.ReportInterval = minReportInterval > 100 ? minReportInterval : 100;
            lightSensor.ReadingChanged += LightSensorOnReadingChanged;
            
            kminAcceleroInit();
            kminLightInit();
        }

        protected void kminAcceleroInit()
        {
            double[][] rawData = new double[2][];
            rawData[0] = new double[] { 0.0, 0.0, 0.0 };
            rawData[1] = new double[] { 1, 1, 1 };
            kminAccelero = new Kmin(rawData, 2);
        }

        protected void kminLightInit()
        {
            this.lightClusters = new String[3];
            this.lightClusters[0] = "";
            this.lightClusters[1] = "";
            this.lightClusters[2] = "";
            double[][] rawData = new double[3][];
            rawData[0] = new double[] { 0.0 };
            rawData[1] = new double[] { 28 };
            rawData[2] = new double[] { 60 };
            kminLight = new Kmin(rawData, 3);
        }

        protected void kminLightExec()
        {
            kminLight.computeClusters();
            actuLightState();
        }

        protected void kminAcceleroExec()
        {
            kminAccelero.computeClusters();
            actuBiggestShockCluster();
        }

        /// <summary>
        /// Invoqué lorsque cette page est sur le point d'être affichée dans un frame.
        /// </summary>
        /// <param name="e">Données d'événement décrivant la manière dont l'utilisateur a accédé à cette page.
        /// Ce paramètre est généralement utilisé pour configurer la page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            // TODO: préparer la page pour affichage ici.

            // TODO: si votre application comporte plusieurs pages, assurez-vous que vous
            // gérez le bouton Retour physique en vous inscrivant à l’événement
            // Événement Windows.Phone.UI.Input.HardwareButtons.BackPressed.
            // Si vous utilisez le NavigationHelper fourni par certains modèles,
            // cet événement est géré automatiquement.
        }

        private void acceleroButton_Click(object sender, RoutedEventArgs e)
        {
            this.updateAcceleroPaused = !this.updateAcceleroPaused;
            if (this.updateAcceleroPaused)
            {
                acceleroButton.Content = "Acquérir accelero";
                kminAcceleroExec();
            }
            else
            {
                acceleroButton.Content = "Arrêter";
                kminAcceleroInit();
            }
        }

        private void lightButton_Click(object sender, RoutedEventArgs e)
        {
            this.updateLightPaused = !this.updateLightPaused;
            if (this.updateLightPaused)
            {
                lightButton.Content = "Acquérir lumière";
                kminLightExec();
            }
            else
            {
                lightButton.Content = "Arrêter";
                kminLightInit();
            }
        }

        private void shockButton_Click(object sender, RoutedEventArgs e)
        {
            shockButton.Content = "";
        }

        async void accelerometerHandler(Accelerometer sender, AccelerometerReadingChangedEventArgs args)
        {
            if (capturing)
            {
                await Dispatcher.RunAsync(CoreDispatcherPriority.Normal, () =>
                {
                    AccelerometerReading reading = args.Reading;
                    double ax = reading.AccelerationX;
                    double ay = reading.AccelerationY;
                    double az = reading.AccelerationZ;
                    double diffAx = Math.Abs(ax - previousAx);
                    double diffAy = Math.Abs(ay - previousAy);
                    double diffAz = Math.Abs(az - previousAz);
                    previousAx = ax;
                    previousAy = ay;
                    previousAz = az;
                    if (!this.updateAcceleroPaused)
                        kminAccelero.addValues(new double[] { diffAx, diffAy, diffAz});
                    else if(kminAccelero.getDataSize() > 2)
                        handleAccelero(diffAx, diffAy, diffAz);

                });
            }
        }

        protected void handleAccelero(double diffAx, double diffAy, double diffAz)
        {
            if (isInShockCluster(diffAx, diffAy, diffAz)){
                shockButton.Content = "SECOUSSE !!!";
            }
        }

        protected Boolean isInShockCluster(double diffAx, double diffAy, double diffAz)
        {
            double[] data = new double []{ diffAx, diffAy, diffAz };
            return getBestClusterFromData(kminAccelero.getMeans(),data) == biggestShockCluster;
        }

        protected void actuBiggestShockCluster()
        {
            biggestShockCluster = getBiggestCluster(kminAccelero.getMeans());
        }

        protected void actuLightState()
        {
            double[][] means = kminLight.getMeans();
            List<int> clusters = new List<int>();
            for(int c = 0; c < means.Length; c++)
            {
                int i = 0;
                foreach(int n in clusters)
                    if (means[c][0] > means[n][0])
                        i++;
                clusters.Insert(i, c);
            }
            lightClusters[clusters[0]] = "Sombre";
            lightClusters[clusters[1]] = "Normale";
            lightClusters[clusters[2]] = "Trop de lumière";
        }

        async void LightSensorOnReadingChanged(Windows.Devices.Sensors.LightSensor sender, Windows.Devices.Sensors.LightSensorReadingChangedEventArgs args)
        {
            await Dispatcher.RunAsync(CoreDispatcherPriority.Normal,
                () =>
                {
                    double[] light = new double[] { args.Reading.IlluminanceInLux };
                    if (!updateLightPaused)
                        kminLight.addValues(light);
                    else if (lightClusters != null )
                    {
                        int cluster = getBestClusterFromData(kminLight.getMeans(), light);
                        lightLabel.Text = lightClusters[cluster];
                    }
                }
                );
        }

        protected int getBiggestCluster(double[][] means)
        {
            double biggest = 0;
            int biggestCluster = 0;
            for (int c = 0; c < means.Length; c++)
            {
                double current = 0;
                for (int i = 0; i < means[c].Length; i++)
                    current += means[c][i];
                if (current > biggest)
                {
                    biggest = current;
                    biggestCluster = c;
                }
            }
            return biggestCluster;
        }

        protected int getBestClusterFromData(double[][] means, double[] data )
        {
            int bestCluster = 0;
            double diff = 900000;
            for(int c = 0; c < means.Length; c++)
            {
                double currentDiff = 0;
                for (int i = 0; i < means[c].Length; i++)
                    currentDiff += Math.Abs(means[c][i]-data[i]);
                if(currentDiff < diff)
                {
                    diff = currentDiff;
                    bestCluster = c;
                }
            }
            return bestCluster;
        }


    }
}
