//
//  PBBeaconDetectionTableViewController.m
//  PolytechBeacon
//
//  Created by Kinan on 15/11/14.
//  Copyright (c) 2014 Kinan Arnaout. All rights reserved.
//

#import "PBBeaconDetectionTableViewController.h"
@import CoreLocation;

@interface PBBeaconDetectionTableViewController () <CLLocationManagerDelegate>

@property NSMutableArray *allBeacons;
@property CLLocationManager *locationManager;
@property CLBeaconRegion *beaconRegion;

@end

@implementation PBBeaconDetectionTableViewController

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    //self.allBeacons = [[NSMutableArray alloc] initWithArray:@[@"beacon 1", @"beacon 2", @"beacon 3", @"beacon 4"]];
    
    
    // Instiate LocationManager
    self.locationManager = [[CLLocationManager alloc] init];
    self.locationManager.delegate = self;
    
    // Create Region to monitor
    NSUUID *beaconUUID = [[NSUUID alloc] initWithUUIDString:@"B9407F30-F5F8-466E-AFF9-25556B57FE6D"];
    self.beaconRegion = [[CLBeaconRegion alloc] initWithProximityUUID:beaconUUID identifier:beaconUUID.UUIDString];
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [self.locationManager startRangingBeaconsInRegion:self.beaconRegion];
}


- (void)viewWillDisappear:(BOOL)animated
{
    [self.locationManager stopRangingBeaconsInRegion:self.beaconRegion];
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - LocationManager delegate

- (void)locationManager:(CLLocationManager *)manager didRangeBeacons:(NSArray *)beacons inRegion:(CLBeaconRegion *)region
{
    self.allBeacons = [[NSMutableArray alloc] initWithArray:beacons];
    
    [self.tableView reloadData];

}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    return self.allBeacons.count;
}


- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return @"";
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"BeaconCell" forIndexPath:indexPath];
    
    CLBeacon *beacon = [self.allBeacons objectAtIndex:indexPath.row];
    NSString *major = [NSString stringWithFormat:@"%d",[[beacon major] integerValue]];
    NSString *minor = [NSString stringWithFormat:@"%d",[[beacon minor] integerValue]];
    NSString *proximity;
    switch([beacon proximity])
    {
        case CLProximityImmediate:
            proximity = @"Immediate";
            break;
            
        case CLProximityNear:
            proximity = @"Near";
            break;
            
        case CLProximityFar:
            proximity = @"Far";
            break;
            
        default:
            proximity = @"Unknown";
            break;
    }
    
    NSString *cellTitle = [NSString stringWithFormat:@"Major : %@ / Minor : %@", major, minor];
    NSString *cellDetail = [NSString stringWithFormat:@"Proximity : %@ / UUID : %@", proximity, [beacon.proximityUUID UUIDString]];

    [cell.textLabel setText:cellTitle];
    [cell.detailTextLabel setText:cellDetail];
    
    return cell;
}



@end
